# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Apply a composed look to all sites in a site collection
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to SharePoint site collection
$siteUrl = "http://sharepoint/sitecollection"

# Relative URL to color palette
$paletteUrl = "/_catalogs/theme/15/Palette015.spcolor"

# Relative URL to font scheme
$fontUrl = "/_catalogs/theme/15/SharePointPersonality.spfont"

# Relative URL for background image
$backgroundUrl = "/_layouts/15/images/image_bg011.jpg"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint site collection
$site = Get-SPSite $siteUrl

# Iterate through each site in the site collection
foreach ($web in $site.AllWebs)
{
	# Check if the site exists
	if ($web.Exists)
	{
		# Apply the composed look elements to the site, specify false to place the generated theme files within the site
		$web.ApplyTheme($paletteUrl, $fontUrl, $backgroundUrl, $false)
	}

	# Dispose of the site object
	$web.Dispose()
}

# Dispose of the site collection object
$site.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 